package pkg240304_nodari_calcolatrice;

import java.awt.*;
import javax.swing.*;
/**
 *
 * @author ross
 */
public class Main extends JFrame{

    private final int WIND_W= 445;
    private final int WIND_H= 720;
    private final int BTN_DIM= 90;
    private final int SPACE_AROUND= 20;
    private final int SPACE_BET= 15;
    private final int INPUT_W= 405;
    private final int INPUT_H= 150;
    private final int START_TH= 190;    //20+150+20
    
    private final String[] car= {"AC","π","%","/","7","8","9","x","4","5","6","-","1","2","3","+","0",",","<","="};
    private final Font font= new Font("Sans-serif", Font.PLAIN, 40);
    private JPanel sfondo;
    private JLabel op;
    private JButton [] tasti;
    //0-3= ac-pi-%-/
    //4-7= 7-8-9-x
    //8-11= 4-5-6--
    //12-15= 1-2-3-+
    //16-19= 0-,-<-=
    
    public Main(){
        super();
        setTitle("CALCOLATRICE");
        setSize(WIND_W,WIND_H);
        setLocation(700, 200);
        setResizable(true);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        sfondo=new JPanel();
        sfondo.setBackground(new Color(28,28,28));
        sfondo.setLayout(null);
        
        //input
        op= new JLabel("");
        setInput();
        
        //bottoni
        tasti=new JButton[20];
        setNames();
        setPositions();
        setFonts_and_Colors();
        addListeners();
        
        
        
        sfondo.add(op);
        addButtons();
        this.add(sfondo);
        this.setVisible(true);
    }
    
    public void setNames(){
        for(int i=0; i<20; i++){
            tasti[i]= new JButton(car[i]);
        }
    }
    public void setPositions(){
        for(int i=0; i<20; i++){
            switch(i){
                case 0: case 4: case 8: case 12: case 16:
                    tasti[i].setBounds(SPACE_AROUND, START_TH+((BTN_DIM+SPACE_BET)*(i/4)), BTN_DIM, BTN_DIM);
                break;
                
                case 1: case 5: case 9: case 13: case 17:
                    tasti[i].setBounds(SPACE_AROUND+BTN_DIM+SPACE_BET, START_TH+(BTN_DIM+SPACE_BET)*(i-1)/4, BTN_DIM, BTN_DIM);
                break;
                
                case 2: case 6: case 10: case 14: case 18:
                    tasti[i].setBounds(SPACE_AROUND+(BTN_DIM+SPACE_BET)*2, START_TH+(BTN_DIM+SPACE_BET)*(i-2)/4, BTN_DIM, BTN_DIM);
                break;
                
                case 3: case 7: case 11: case 15: case 19:
                    tasti[i].setBounds(SPACE_AROUND+(BTN_DIM+SPACE_BET)*3, START_TH+(BTN_DIM+SPACE_BET)*(i-3)/4, BTN_DIM, BTN_DIM);
                break;
                
                default:
                break;
            }
        }
    }
    public void setFonts_and_Colors(){
        for(int i=0; i<20; i++){
            tasti[i].setFont(font);
            tasti[i].setForeground(new Color(193, 183, 181));
            tasti[i].setBorderPainted(false);
            tasti[i].setFocusPainted(false);
            if(i==0){
                tasti[i].setBackground(new Color(114, 90, 29));
            }else if(i==19){
                tasti[i].setBackground(new Color(120, 52, 41));
            }else if(i==1 || i==2 || i==3 || i==7 || i==11 || i==15){
                tasti[i].setBackground(new Color(125, 81, 92));
            }else{
                tasti[i].setBackground(new Color(50, 42, 43));
            }
        }
    }
    public void addButtons(){
        for(int i=0; i<20; i++){
            sfondo.add(tasti[i]);
        }
    }
    public void setInput(){
        op.setBounds(SPACE_AROUND, SPACE_AROUND, INPUT_W, INPUT_H);
        op.setForeground(new Color(193, 183, 181));
        op.setFont(font);
    }
    public void addListeners(){
        for(int i=0; i<20; i++){
            tasti[i].addActionListener(new Ascoltatore(tasti[i],op));
        }
    }
    
    public static void main(String[] args) {
        Main main = new Main();
    }   
}
