/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package pkg240304_nodari_calcolatrice;

import java.util.ArrayList;

/**
 *
 * @author ross
 */
public class Calculations {

    public static String calculate(String expression) {
        try {
            ArrayList<String> tokens = tokenizeExpression(expression);
            ArrayList<String> output = new ArrayList<>();
            ArrayList<String> operators = new ArrayList<>();

            for (String token : tokens) {
                if (isNumeric(token)) {
                    output.add(token);
                } else if (isOperator(token)) {
                    while (!operators.isEmpty() && precedence(operators.get(operators.size() - 1)) >= precedence(token)) {
                        output.add(operators.remove(operators.size() - 1));
                    }
                    operators.add(token);
                }
            }

            output.addAll(operators);

            return calculateOutput(output);
        } catch (Exception e) {
            return "Error";
        }
    }

    private static ArrayList<String> tokenizeExpression(String expression) {
        ArrayList<String> tokens = new ArrayList<>();
        StringBuilder currentToken = new StringBuilder();

        for (char c : expression.toCharArray()) {
            if (Character.isDigit(c) || c == '.') {
                currentToken.append(c);
            } else {
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                    currentToken.setLength(0);
                }
                if (!Character.isWhitespace(c)) {
                    tokens.add(String.valueOf(c));
                }
            }
        }

        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }

        return tokens;
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isOperator(String str) {
        return str.matches("[+\\-x/]");
    }

    private static int precedence(String operator) {
        switch (operator) {
            case "+":
            case "-":
                return 1;
            case "x":
            case "/":
                return 2;
            default:
                return 0;
        }
    }

    private static String calculateOutput(ArrayList<String> output) {
        double result = 0;
        ArrayList<Double> operands = new ArrayList<>();

        for (String token : output) {
            if (isNumeric(token)) {
                operands.add(Double.parseDouble(token));
            } else if (isOperator(token)) {
                double op2 = operands.remove(operands.size() - 1);
                double op1 = operands.remove(operands.size() - 1);
                operands.add(performOperation(op1, op2, token));
            }
        }

        if (operands.size() == 1) {
            result = operands.get(0);
        }

        return String.valueOf(result);
    }

    private static double performOperation(double operand1, double operand2, String operator) {
        switch (operator) {
            case "+":
                return operand1 + operand2;
            case "-":
                return operand1 - operand2;
            case "x":
                return operand1 * operand2;
            case "/":
                if (operand2 == 0) {
                    throw new ArithmeticException("Division by zero");
                }
                return operand1 / operand2;
            default:
                throw new IllegalArgumentException("Invalid operator");
        }
    }
}

