package pkg240304_nodari_calcolatrice;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;
import java.awt.*;

public class Ascoltatore extends Calculations implements ActionListener {
    private JButton btn;
    private JLabel lab;
    private static String result;

    public Ascoltatore(JButton btn, JLabel lab) {
        this.btn = btn;
        this.lab = lab;
        result="";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String car = e.getActionCommand();
        switch (car) {
            case "AC":
                result = "";
                lab.setText(result);
                break;
            case "π":
                if (!result.isEmpty()) {
                    result = String.valueOf(Float.parseFloat(result) * 3.14);
                    lab.setText(result);
                }
                break;
            case "%":
                if (!result.isEmpty()) {
                    result = String.valueOf(Float.parseFloat(result) * 0.01);
                    lab.setText(result);
                }
                break;
            case "/":
            case "x":
            case "-":
            case "+":
            case ",":
                if (!result.isEmpty()) {
                    result += car;
                    lab.setText(result);
                }
                break;
            case "<":
                if (result.length() > 0) {
                    result = result.substring(0, result.length() - 1);
                    lab.setText(result);
                }
                break;
            case "=":
                if (!result.isEmpty() && (result.contains("+") || result.contains("-") || result.contains("x") || result.contains("/"))) {
                    if (result.charAt(result.length() - 1) == '+' || result.charAt(result.length() - 1) == '-' || result.charAt(result.length() - 1) == 'x' || result.charAt(result.length() - 1) == '/') {
                        result = "Error";
                    } else {
                        try {
                            result = calculate(result);
                            lab.setText(result);
                            result="";
                        } catch (NumberFormatException ex){
                            result = "Error";
                        }catch( IllegalArgumentException | ArithmeticException ex){
                            result= "Error";
                        }
                    }
                }
                break;
            default:
                result += car;
                lab.setText(result);
                break;
        }
    }
}